//##############################################################################
//# FILE: RotateTransition.java
//# VERSION: 1.21
//# DATE: 3/29/96
//# AUTHOR: Robert Temple (templer@db.erau.edu)
//##############################################################################

import java.awt.image.MemoryImageSource;
import java.awt.Image;
import java.lang.Math;

//##############################################################################
//# CLASS: RotateTransition
//#
//# The RotateTransition class changes one image into another by making it
//# appear as if one image is rotating upward from below the other image.
//# it might appear as if the images are on a cube with the current image 
//# facing you, and the next image on the bottom of the cube, but slowly
//# moving up to fact you.
//#
//# USAGE NOTE:
//##############################################################################
//# STATIC CONSTANT: FRAMES
//#   The total number of frames this transition will show on the screen before
//#   the new image is shown in its entirety
//# VARIABLE: rotate_amount
//#   The vertical amount the image rotates upward each frame
//# VARIABLE: location
//#   The current vertical index at which the current and next image are
//#   end and start respectively.
//# CONSTRUCTOR
//#   initialize all of the member variables
//# METHOD: Rotate
//#   Create the next frame in the work pixel array
//##############################################################################
public class RotateTransition extends BillTransition {
  //### STATIC MEMBERS
  final static int FRAMES = 8;
  final static double SIN_45_DEGREES = 0.707106781d;

  //### INSTANCE MEMBERS
  int rotate_amount;
  int location;

  double current_angle;
  double angle_increase;
  double perpen;

  public RotateTransition() {
    super(FRAMES);
    delay = 200;

    angle_increase = (Math.PI / 2.0d) * (1.0d / (double)(FRAMES + 1));

    current_angle = angle_increase;

    perpen = ((double)image_h / 2.0d) * SIN_45_DEGREES;

    for(int f = 0; f < number_of_frames; ++f) {

      //# give other threads a shot at the CPU
      try {
        Thread.sleep(100);
      } catch (InterruptedException e) {}

      Rotate();

      //# give other threads a shot at the CPU
      try {
        Thread.sleep(100);
      } catch (InterruptedException e) {}

      //# create the new frame image from the work pixels
      frames[f] = owner.createImage(new MemoryImageSource(image_w,
                image_h, work_pixels, 0, image_w));

      owner.prepareImage(frames[f], owner);

      current_angle += angle_increase;
    }

    //# we don't need the work pixels anymore
    work_pixels = null;
  }

  final void Rotate() {
    //# calculate the portion of the top billboard that can be seen
    double top_billboard_h = ((double)image_h / 2d * 
		Math.sin(Math.PI / 2d - current_angle)) + 
		(double)image_h / 2d;
  
    //# calculate the portion of the bottom billboard that can be seen
    double bottom_billboard_h = ((double)image_h / 2d * Math.sin(current_angle)) + 
		(double)image_h / 2d;

    //# calculate the vertical location that the top billboard ends and the 
    //# next billboard starts
    int location = image_h - (int)(bottom_billboard_h * Math.sin(current_angle));

    //# calculate the vertical adder to determine the vertical position 
    //# to take pixels from the source image
    float adder = (float)top_billboard_h / (float)location;

    //# the current vertical location on the source image to grab pixels from
    float position = (float)image_h - (float)top_billboard_h + adder - 1f;

    //# draw int the top billboard
    for(int y = 0; y < location; ++y) {
      System.arraycopy((Object)
              owner.billboards[owner.current_billboard].image_pixels,
              (int)position * image_w, (Object)work_pixels,
              y * image_w, image_w);

      position += adder;
    }

    adder = (float)bottom_billboard_h / (float)(image_h - location);
    position = 0f;

    // draw in the bottom billboard
    for(int y = location; y < image_h; ++y) {
      System.arraycopy((Object)
              owner.billboards[owner.next_billboard].image_pixels,
              (int)position * image_w, (Object)work_pixels,
              y * image_w, image_w);
      position += adder;
    }

  }
}
